/*
File:relay.h
Memo:把继电器相关的函数都放在这里，方便移植到使用常规继电器的项目
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#include "private/relay.h"

unsigned char relayActive = 0;

void RELAY_ON()
{
    if (relayActive > 0) // 如果动作正在执行，必须等待
    {
        return;
    }

    if (0 == sconfig.reverse)
    {
        digitalWrite(INA, LOW);
        digitalWrite(INB, HIGH);
    }
    else
    {
        digitalWrite(INA, HIGH);
        digitalWrite(INB, LOW);
    }

    relayActive = 1;
    TickerRELAY.attach(0.1, RELAY_Ticker);
}

void RELAY_OFF()
{
    if (relayActive > 0) // 如果动作正在执行，必须等待
    {
        return;
    }

    if (0 == sconfig.reverse)
    {
        digitalWrite(INA, HIGH);
        digitalWrite(INB, LOW);
    }
    else
    {
        digitalWrite(INA, LOW);
        digitalWrite(INB, HIGH);
    }

    relayActive = 1;
    TickerRELAY.attach(0.1, RELAY_Ticker);
}

void RELAY_KEEP()
{
    digitalWrite(INA, LOW);
    digitalWrite(INB, LOW);

    relayActive = 0;
    TickerRELAY.detach();
}

void switch_RELAY()
{
    if (0 == sconfig.relay)
    {
        set_RELAY(1);
        return;
    }

    set_RELAY(0);
}

void set_RELAY(unsigned char value)
{
    if (relayActive > 0)    //如果动作正在执行，必须等待
    {
        return;
    }

    set_LED(value);
    sconfig.relay = value;

    if (1 == value)
    {
        RELAY_ON();
        return;
    }

    RELAY_OFF();
}

void RELAY_Ticker()
{
    if (0 >= relayActive)
    {
        return;
    }

    if (relayActive > 1)
    {
        RELAY_KEEP();
        return;
    }

    relayActive++; // ==1,在动作状态再延时0.1秒，确定动作被执行
}

void mqtt_switch_RELAY()
{
    if (1 == sconfig.relay)
    {
        mqtt_set_RELAY(0);
    }
    else
    {
        mqtt_set_RELAY(1);
    }
}

void mqtt_set_RELAY(unsigned char value)
{
    unsigned char old = sconfig.relay;
    set_RELAY(value);
    if (value == old)
    {
        return;
    }

    needMQTTup = 1;
    needSaveStatus = 1;
}