/*
File:hook.h
Memo:钩子函数，在通用函数中放置钩子，在私有函数中具体实现不同的功能。
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#include "private/hook.h"

void setup_hook()
{
    pinMode(INA, OUTPUT);
    pinMode(INB, OUTPUT);
}

void boot_Init_hook()
{
    set_RELAY(sconfig.relay);
    return;
}

void boot_OK_hook()
{
    return;
}

unsigned char needReadChip = 0;
void loop_hook()
{
    if (1 == needReadChip)
    {
        needReadChip = 0;
        readChip();
    }
}

void OTA_update_hook()
{
    return;
}

void One_Tenth_Of_Second_Ticker_hook()
{
    RELAY_Ticker();
}

void One_Second_Ticker_hook()
{
    unsigned char t = getTimer();
    if (1 == t)
    {
        mqtt_set_RELAY(1);
        return;
    }

    if (2 == t)
    {
        mqtt_set_RELAY(0);
        return;
    }
}

void onMqttConnect_hook()
{
    InitReadChip();
}

void onMqttMessage_hook(String msg, String str)
{
    if (msg == String("led"))
    {
        sconfig.led = atoi(str.c_str());
        needSaveStatus = 1;
        return;
    }

    if (msg == String("on"))
    {
        sconfig.relay = atoi(str.c_str());
        mqtt_set_RELAY(sconfig.relay);
        needSaveStatus = 1;
        return;
    }

    if (msg == String("countdown"))
    {
        sconfig.countdown = atoi(str.c_str());
        needSaveStatus = 1;
        return;
    }

    if (msg == String("vrate"))
    {
        mconfig.vrate = atof(str.c_str());
        if ((0 >= mconfig.vrate) or (mconfig.vrate > 2))
        {
            mconfig.vrate = VolRate;
        }
        saveMQTTConfig();
        return;
    }

    if (msg == String("crate"))
    {
        mconfig.crate = atof(str.c_str());
        if ((0 >= mconfig.crate) or (mconfig.crate > 2))
        {
            mconfig.crate = CurrentRate;
        }
        saveMQTTConfig();
        return;
    }

    if (msg == String("prate"))
    {
        mconfig.prate = atof(str.c_str());
        if ((0 >= mconfig.prate) or (mconfig.prate > 2))
        {
            mconfig.prate = PowerRate;
        }
        saveMQTTConfig();
        return;
    }

    if (msg == String("reverse"))
    {
        sconfig.reverse = atoi(str.c_str());
        needSaveStatus = 1;
        return;
    }
}

float voltage0 = 0;
float current0 = 0;
float power0 = 0;
float energy0 = 0;
float freq0 = 0;
void mqtt_Up_Status_hook(StaticJsonDocument<1024> &doc)
{
    doc["on"] = sconfig.relay;
    doc["countdown"] = sconfig.countdown;
    doc["starttime"] = sconfig.starttime;
    doc["endtime"] = sconfig.endtime;
    doc["timer"] = sconfig.timer;
    doc["reverse"] = sconfig.reverse;

    float voltage = getVoltage();
    float current = getCurrent();
    float power = getActivePower();
    float energy = getEnergy();
    float freq = getFREQ();
    unsigned long subtime = rawTime() - lastPublishTime;
    bool needChange = false;

    if (subtime >= 5)
    {
        needChange = true;
    }
    else
    {
        if (absrate(voltage0, voltage) >= mqttChangeRate)
        {
            needChange = true;
        }
        if (absrate(current0, current) >= mqttChangeRate)
        {
            needChange = true;
        }
        if (absrate(power0, power) >= mqttChangeRate)
        {
            needChange = true;
        }
        if (absrate(energy0, energy) >= mqttChangeRate)
        {
            needChange = true;
        }
        if (absrate(freq0, freq) >= mqttChangeRate)
        {
            needChange = true;
        }
    }

    if (needChange)
    {
        voltage0 = voltage;
        current0 = current;
        power0 = power;
        energy0 = energy;
        freq0 = freq;
    }

    doc["voltage"] = floatRound(voltage0, 2);
    doc["current"] = floatRound(current0, 2);
    doc["power"] = floatRound(power0, 2);
    doc["energy"] = floatRound(energy0 + KWh0, 4);
    doc["freq"] = floatRound(freq0, 1);
    doc["pows"] = String(doc["voltage"]) + String("V/") + String(doc["current"]) + String("mA/") + String(doc["power"]) + String("W/") + String(doc["energy"]) + String("kWh/") + String(doc["freq"]) + String("Hz");
}

void publishMQTTdiscoverys_hook(bool clearmqtt)
{
    StaticJsonDocument<512> doc;

    // led
    String topic = String("homeassistant/switch/{clientId}_led/config");
    doc["name"] = "led";
    doc["unique_id"] = "{clientId}_led";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["payload_on"] = "{\"m\":\"led\",\"v\":\"1\"}";
    doc["payload_off"] = "{\"m\":\"led\",\"v\":\"0\"}";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.led }}";
    doc["state_on"] = "1";
    doc["state_off"] = "0";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // switch
    topic = String("homeassistant/switch/{clientId}_switch/config");
    doc["name"] = "switch";
    doc["unique_id"] = "{clientId}_switch";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["payload_on"] = "{\"m\":\"on\",\"v\":\"1\"}";
    doc["payload_off"] = "{\"m\":\"on\",\"v\":\"0\"}";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.on }}";
    doc["state_on"] = "1";
    doc["state_off"] = "0";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // timer
    topic = String("homeassistant/switch/{clientId}_timer/config");
    doc["name"] = "timer";
    doc["unique_id"] = "{clientId}_timer";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["payload_on"] = "{\"m\":\"timer\",\"v\":\"1\"}";
    doc["payload_off"] = "{\"m\":\"timer\",\"v\":\"0\"}";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.timer }}";
    doc["state_on"] = "1";
    doc["state_off"] = "0";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // voltage
    topic = String("homeassistant/sensor/{clientId}_voltage/config");
    doc["name"] = "voltage";
    doc["unique_id"] = "{clientId}_voltage";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.voltage }}";
    doc["unit_of_measurement"] = "V";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // current
    topic = String("homeassistant/sensor/{clientId}_current/config");
    doc["name"] = "current";
    doc["unique_id"] = "{clientId}_current";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.current }}";
    doc["unit_of_measurement"] = "mA";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // power
    topic = String("homeassistant/sensor/{clientId}_power/config");
    doc["name"] = "power";
    doc["unique_id"] = "{clientId}_power";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.power }}";
    doc["unit_of_measurement"] = "W";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // energy
    topic = String("homeassistant/sensor/{clientId}_energy/config");
    doc["name"] = "energy";
    doc["unique_id"] = "{clientId}_energy";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.energy }}";
    doc["unit_of_measurement"] = "kWh";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // pows
    topic = String("homeassistant/sensor/{clientId}_pows/config");
    doc["name"] = "pows";
    doc["unique_id"] = "{clientId}_pows";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.pows }}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // starttime
    topic = String("homeassistant/text/{clientId}_starttime/config");
    doc["name"] = "starttime";
    doc["unique_id"] = "{clientId}_starttime";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.starttime }}";
    doc["command_template"] = "{\"m\":\"starttime\",\"v\":\"{{ value }}\"}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // endtime
    topic = String("homeassistant/text/{clientId}_endtime/config");
    doc["name"] = "endtime";
    doc["unique_id"] = "{clientId}_endtime";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.endtime }}";
    doc["command_template"] = "{\"m\":\"endtime\",\"v\":\"{{ value }}\"}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // vrate
    topic = String("homeassistant/text/{clientId}_vrate/config");
    doc["name"] = "vrate";
    doc["unique_id"] = "{clientId}_vrate";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.vrate }}";
    doc["command_template"] = "{\"m\":\"vrate\",\"v\":\"{{ value }}\"}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // crate
    topic = String("homeassistant/text/{clientId}_crate/config");
    doc["name"] = "crate";
    doc["unique_id"] = "{clientId}_crate";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.crate }}";
    doc["command_template"] = "{\"m\":\"crate\",\"v\":\"{{ value }}\"}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // prate
    topic = String("homeassistant/text/{clientId}_prate/config");
    doc["name"] = "prate";
    doc["unique_id"] = "{clientId}_prate";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.prate }}";
    doc["command_template"] = "{\"m\":\"prate\",\"v\":\"{{ value }}\"}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // switch reverse
    topic = String("homeassistant/switch/{clientId}_reverse/config");
    doc["name"] = "reverse";
    doc["unique_id"] = "{clientId}_reverse";
    doc["state_topic"] = "{topic}/stat";
    doc["command_topic"] = "{topic}/in";
    doc["payload_on"] = "{\"m\":\"on\",\"v\":\"1\"}";
    doc["payload_off"] = "{\"m\":\"on\",\"v\":\"0\"}";
    doc["qos"] = "2";
    doc["value_template"] = "{{ value_json.on }}";
    doc["state_on"] = "1";
    doc["state_off"] = "0";
    publishMQTTdiscovery(topic, doc, clearmqtt);
}

void loadStatusConfig_hook(StaticJsonDocument<1024> &doc)
{
    sconfig.KWh = String(doc["KWh"]).toFloat();
    sconfig.reverse = doc["reverse"] ? (unsigned char)String(doc["reverse"]).toInt() : 0;
    sconfig.clearmqtt = doc["clearmqtt"] ? (unsigned char)String(doc["clearmqtt"]).toInt() : 0;
}

void saveStatusConfig_hook(StaticJsonDocument<1024> &doc)
{
    doc["KWh"] = sconfig.KWh;
    doc["reverse"] = sconfig.reverse;
    doc["clearmqtt"] = sconfig.clearmqtt;
}

void getStatusConfigString_hook(StaticJsonDocument<1024> &doc)
{
    doc["KWh"] = sconfig.KWh;
    doc["reverse"] = sconfig.reverse;
    doc["clearmqtt"] = sconfig.clearmqtt;
}

void loadMQTTConfig_hook(StaticJsonDocument<1024> &doc)
{
    mconfig.vrate = doc["vrate"] ? doc["vrate"] : VolRate;
    mconfig.crate = doc["crate"] ? doc["crate"] : CurrentRate;
    mconfig.prate = doc["prate"] ? doc["prate"] : PowerRate;
}

void getMQTTConfigString_hook(StaticJsonDocument<1024> &doc)
{
    doc["vrate"] = mconfig.vrate;
    doc["crate"] = mconfig.crate;
    doc["prate"] = mconfig.prate;
}

void Timer_hook()
{
    needReadChip = 1;
    LED_CONSTANT_LIGHT();

    // 返回0，定时器未启用
    // 返回1，已到启用时间，开关开
    // 返回2，已到启用时间，开关关
    // 返回3，未到启用时间
    unsigned char flag = getTimer();
    if (1 == flag)
    {
        set_RELAY(1);
        return;
    }

    if (2 == flag)
    {
        set_RELAY(0);
        return;
    }

    if (1 == getCountdown())
    {
        switch_RELAY();
        return;
    }

    return;
}

void KeyPress_hook()
{
    mqtt_switch_RELAY();
}