/*
File:bl0937.h
Memo:读取计量芯片的电能数据，尝试兼容不同的计量芯片
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __BL0942_H__
#define __BL0942_H__

#include <Arduino.h>

#include "common/common.h"
#include "private/config.h"

#define V_REF 1.218
#define RL_CURRENT 1    // 0.001欧,单位为毫欧
#define R2_VOLTAGE 1950 // 390K*5,单位为K欧
#define R1_VOLTAGE 0.51 // 0.51K,单位为K欧

void InitReadChip();
void readChip();
void sendCommandForRead();
bool readData();
String getDebugInfo();

float getCurrent();
float getFastCurrent();
float getVoltage();
float getActivePower();
float getEnergy();
float getFREQ();
int getSTATUS();

#endif