/*
File:ota.h
Memo:OTA空中升级相关函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/ota.h"

unsigned char isOTA = 0;
void OTA_update()
{
    if (1 == isOTA)
    {
        Serial.println("OTA is updating.");
        return;
    }

    OTA_update_hook();
    isOTA = 1;
    delay(100);
    Serial.begin(74800);
    delay(100);
    Serial.print("OTA update:");
    Serial.println(mconfig.ota);

    WiFiClient client;
    ESPhttpUpdate.setLedPin(LED, LOW);
    ESPhttpUpdate.onStart(OTA_started);
    ESPhttpUpdate.onEnd(OTA_finished);
    ESPhttpUpdate.onProgress(OTA_progress);
    ESPhttpUpdate.onError(OTA_error);
    ESPhttpUpdate.rebootOnUpdate(true);
    ESPhttpUpdate.update(client, mconfig.ota);
}

void OTA_started()
{
    Serial.println("OTA started.");
}

void OTA_error(int err)
{
    Serial.print("OTA ERROR:");
    Serial.print(err);
    Serial.print(",message:");
    Serial.println(ESPhttpUpdate.getLastErrorString());
}

void OTA_progress(int cur, int total)
{
    Serial.print("progress:");
    Serial.print(cur);
    Serial.print("/");
    Serial.print(total);
    Serial.println("bytes");
}

void OTA_finished()
{
    Serial.println("OTA Finished,device reboot...");
}