/*
File:mqtt.h
Memo:MQTT相关函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/mqtt.h"

AsyncMqttClient mqtt;

void InitMQTT()
{
    ESP.wdtFeed();
    Serial.print("M...");

    String willString = mconfig.topic + String("/stat");
    const char *topic = strdup(willString.c_str());
    const char *clientId = strdup(mconfig.clientId.c_str());

    mqtt.setClientId(clientId);
    mqtt.onConnect(onMqttConnect);
    mqtt.onDisconnect(onMqttDisconnect);
    mqtt.onMessage(onMqttMessage);
    mqtt.setKeepAlive(10).setCleanSession(false).setWill(topic, 2, false, "{\"state\":0}");
    mqtt.setServer(mconfig.host.c_str(), mconfig.port);
    if ((mconfig.username != String("")) and (mconfig.password != String("")))
    {
        mqtt.setCredentials(mconfig.username.c_str(), mconfig.password.c_str());
    }

    mqtt.connect();
}

void onMqttConnect(bool sessionPresent)
{
    if (0 == WIFIinInit)
    {
        return;
    }

    mqtt.subscribe((mconfig.topic + String("/in")).c_str(), 2);
    Serial.println("============MQTT Connect============");
    needMQTTup = 1;
    mqttIsConnect = 1;
    WIFIinInit = 0;
    lastPublishTime = rawTime();

    onMqttConnect_hook();
    publishMQTTdiscoverys();
    boot_OK();
}

void onMqttDisconnect(AsyncMqttClientDisconnectReason reason)
{
    if (0 == WIFIinInit)
    {
        return;
    }

    mqttIsConnect = 0;
    WIFIinInit = 0;
    Serial.println("Disconnected from MQTT.");

    /*
    Serial.println("Reason:");
    if (reason == AsyncMqttClientDisconnectReason::TCP_DISCONNECTED)
    {
        Serial.println("TCP_DISCONNECTED");
    }
    else if (reason == AsyncMqttClientDisconnectReason::MQTT_UNACCEPTABLE_PROTOCOL_VERSION)
    {
        Serial.println("MQTT_UNACCEPTABLE_PROTOCOL_VERSION");
    }
    else if (reason == AsyncMqttClientDisconnectReason::MQTT_IDENTIFIER_REJECTED)
    {
        Serial.println("MQTT_IDENTIFIER_REJECTED");
    }
    else if (reason == AsyncMqttClientDisconnectReason::MQTT_SERVER_UNAVAILABLE)
    {
        Serial.println("MQTT_SERVER_UNAVAILABLE");
    }
    else if (reason == AsyncMqttClientDisconnectReason::MQTT_MALFORMED_CREDENTIALS)
    {
        Serial.println("MQTT_MALFORMED_CREDENTIALS");
    }
    else if (reason == AsyncMqttClientDisconnectReason::MQTT_NOT_AUTHORIZED)
    {
        Serial.println("MQTT_NOT_AUTHORIZED");
    }
    else if (reason == AsyncMqttClientDisconnectReason::ESP8266_NOT_ENOUGH_SPACE)
    {
        Serial.println("ESP8266_NOT_ENOUGH_SPACE");
    }
    else if (reason == AsyncMqttClientDisconnectReason::TLS_BAD_FINGERPRINT)
    {
        Serial.println("TLS_BAD_FINGERPRINT");
    }
    */
}

unsigned char count = 0;
void onMqttMessage(char *topic, char *payload, AsyncMqttClientMessageProperties properties, size_t len, size_t index, size_t total)
{
    // 如果是retain消息，相当于say hello，直接丢弃
    if (properties.retain)
    {
        return;
    }

    char chars[len];
    strlcpy(chars, payload, len + 1);
    String str = String(chars);
    // String str = String(payload);不能直接用String强制转换，否则会多出来东西

    if (String(topic) != (mconfig.topic + String("/in")))
    {
        Serial.print("topic in:");
        Serial.println(str);
        return;
    }

    StaticJsonDocument<1024> doc;
    DeserializationError error = deserializeJson(doc, str);
    if (error)
    {
        Serial.println("Failed to deserializeJson str");
        return;
    }

    String msg = String(doc["m"]);
    str = String(doc["v"]);

    if (msg == String("timer"))
    {
        sconfig.timer = atoi(str.c_str());
        needSaveStatus = 1;
        return;
    }

    if (msg == String("starttime"))
    {
        sconfig.starttime = str;
        needSaveStatus = 1;
        return;
    }

    if (msg == String("endtime"))
    {
        sconfig.endtime = str;
        needSaveStatus = 1;
        return;
    }

    if (msg == String("ota"))
    {
        needOTA = 1;
        return;
    }

    if (msg == String("ntp"))
    {
        if (str == String("1"))
        {
            needNTP = 1;
            return;
        }
    }

    if (msg == String("debug"))
    {
        if (str == String("1"))
        {
            debug = true;
            return;
        }
        else
        {
            debug = false;
            return;
        }
    }

    if (msg == String("otaurl"))
    {
        mconfig.ota = str;
        Serial.print("ota url:");
        Serial.println(str);
        saveMQTTConfig();
        return;
    }

    onMqttMessage_hook(msg, str);

    Serial.print("topic msg:");
    Serial.println(msg);
    Serial.print("str:");
    Serial.println(str);
}

String md5mqtt = "";
unsigned char pubFail = 0;
void mqtt_Up_Status()
{
    if (1 != mqttIsConnect)
    {
        return;
    }

    StaticJsonDocument<1024> doc;
    doc["state"] = 1;
    doc["led"] = sconfig.led;
    doc["version"] = version;
    doc["debug"] = debug ? 1 : 0;
    doc["info"] = getMqttDebugInfo();
    mqtt_Up_Status_hook(doc);

    String timestr = getTime();
    String jsonstr, md5;
    serializeJson(doc, jsonstr);
    md5 = md5String(jsonstr);
    jsonstr.clear();
    unsigned long time = rawTime();
    unsigned long subtime = time - lastPublishTime;

    // 再次发送间隔不到1秒
    if (1 > subtime)
    {
        return;
    }

    // 间隔在1-5秒并且发送数据和上次的相同
    if ((5 > subtime) and (md5 == md5mqtt))
    {
        return;
    }

    md5mqtt = md5;
    doc["time"] = timestr;
    lastPublishTime = time;
    serializeJson(doc, jsonstr);
    uint16_t pkid = mqtt.publish((mconfig.topic + String("/stat")).c_str(), 2, false, jsonstr.c_str());
    // Serial.print("Publishing at QoS 2, packetId: ");
    // Serial.println(pkid);

    if (pkid > 0)
    {
        pubFail = 0;
        return;
    }

    pubFail++;
    if (pubFail >= 5)
    {
        Serial.println("MQTT Publish Fail over 5 times,disconnect MQTT.");
        mqttIsConnect = 0;
        mqtt.disconnect();
    }
}

String getMqttDebugInfo()
{
    return debug ? getDebugInfo() : String("");
}

void publishMQTTdiscovery(String topic, StaticJsonDocument<512> &doc, bool clearmqtt)
{
    StaticJsonDocument<512> docDevice;

    String clientId = mconfig.clientId;
    clientId.replace("-", "_");
    clientId.toLowerCase();
    topic.replace("{clientId}", clientId);

    String name = clientId;
    name.toUpperCase();
    docDevice["name"] = name;
    docDevice["model"] = model;
    docDevice["sw_version"] = version;
    docDevice["manufacturer"] = "oldfox126";
    docDevice["identifiers"] = "{clientId}_";

    if (clearmqtt)
    {
        //Serial.print("MQTT Clear config=");
        //Serial.println(topic);
        mqtt.publish(topic.c_str(), 2, false, "{}");
        delay(20);
    }

    doc["device"] = docDevice;
    String jsonstr;
    serializeJson(doc, jsonstr);
    docDevice.clear();
    doc.clear();

    jsonstr.replace("{clientId}", clientId);
    jsonstr.replace("{topic}", mconfig.topic);
    mqtt.publish(topic.c_str(), 2, true, jsonstr.c_str());
    delay(20);
}

void publishMQTTdiscoverys()
{
    StaticJsonDocument<512> doc;
    if (0 == sconfig.clearmqtt)
    {
        clearmqtt = true;
    }

    // state
    String topic = String("homeassistant/binary_sensor/{clientId}_state/config");
    doc["name"] = "state";
    doc["unique_id"] = "{clientId}_state";
    doc["state_topic"] = "{topic}/stat";
    doc["qos"] = "2";
    doc["device_class"] = "running";
    doc["value_template"] = "{{ value_json.state }}";
    doc["payload_on"] = "1";
    doc["payload_off"] = "0";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // version
    topic = String("homeassistant/sensor/{clientId}_version/config");
    doc["name"] = "version";
    doc["unique_id"] = "{clientId}_version";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.version }}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    // time
    topic = String("homeassistant/sensor/{clientId}_time/config");
    doc["name"] = "time";
    doc["unique_id"] = "{clientId}_time";
    doc["state_topic"] = "{topic}/stat";
    doc["value_template"] = "{{ value_json.time }}";
    publishMQTTdiscovery(topic, doc, clearmqtt);

    publishMQTTdiscoverys_hook(clearmqtt);

    if (clearmqtt)
    {
        sconfig.clearmqtt = 1;
        saveStatusConfig();
    }
}