/*
File:files.h
Memo:文件操作函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __FILES_H__
#define __FILES_H__

#include <Arduino.h>
#include <ArduinoJson.h>
#include <LittleFS.h>

#include "common/common.h"
#include "common/timeNTP.h"

#include "private/config.h"
#include "private/hook.h"

String readFile(const String filepath);
void printFile(const String filepath);
char writeFile(const String filepath, String str);

void InitJsonConfig();
void loadStatusConfig();
void saveStatusConfig();
String getStatusConfigString();
void printStatusConfig();

void loadMQTTConfig();
void saveMQTTConfig();
String getMQTTConfigString();
void printMQTTConfig();

#endif
