/*
File:files.h
Memo:文件操作函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/files.h"

String readFile(const String filepath)
{
    String str = "";
    if (!LittleFS.begin())
    {
        Serial.println("An Error has occurred while mounting LittleFS");
        return str;
    }

    File file = LittleFS.open(filepath, "r");
    if (!file)
    {
        Serial.print("Failed to open file for reading:");
        Serial.println(filepath);
        return str;
    }

    str = file.readString();
    file.close();
    LittleFS.end();

    return str;
}

void printFile(const String filepath)
{
    String str = readFile(filepath);

    Serial.print("============printFile ");
    Serial.print(filepath);
    Serial.println(" Start============");
    Serial.println(str);
    Serial.println("============printFile End============");
}

char writeFile(const String filepath, String str)
{
    String old = readFile(filepath);
    if (old == str)
    {
        return 0;
    }

    if (!LittleFS.begin())
    {
        Serial.println("An Error has occurred while mounting LittleFS");
        return -1;
    }

    ESP.wdtFeed();
    File file = LittleFS.open(filepath, "w");
    if (!file)
    {
        Serial.println("Failed to open file for writeing");
        return -2;
    }

    file.print(str);
    file.close();
    LittleFS.end();

    return 1;
}

void InitJsonConfig()
{
    loadStatusConfig();
    printStatusConfig();

    loadMQTTConfig();
    printMQTTConfig();
}

void loadStatusConfig()
{
    String str = readFile(statusconfig);
    StaticJsonDocument<1024> doc;
    DeserializationError error = deserializeJson(doc, str);
    if (error)
    {
        Serial.println("Failed to deserializeJson str");
        return;
    }

    sconfig.led = (unsigned char)String(doc["led"]).toInt();
    sconfig.relay = (unsigned char)String(doc["relay"]).toInt();
    sconfig.countdown = (unsigned char)String(doc["countdown"]).toInt();
    sconfig.timer = (unsigned char)String(doc["timer"]).toInt();
    sconfig.starttime = String(doc["starttime"]);
    sconfig.endtime = String(doc["endtime"]);
    sconfig.md5 = String(doc["md5"]);
    sconfig.boottime = doc["boottime"] ? (unsigned long)String(doc["boottime"]).toInt() : 0;
    sconfig.bootfail = doc["bootfail"] ? (unsigned char)String(doc["bootfail"]).toInt() : 0;

    loadStatusConfig_hook(doc);
}

void saveStatusConfig()
{
    ESP.wdtFeed();
    StaticJsonDocument<1024> doc;

    doc["led"] = sconfig.led;
    doc["relay"] = sconfig.relay;
    doc["countdown"] = sconfig.countdown;
    doc["timer"] = sconfig.timer;
    doc["starttime"] = sconfig.starttime;
    doc["endtime"] = sconfig.endtime;
    doc["boottime"] = sconfig.boottime;
    doc["bootfail"] = sconfig.bootfail;

    saveStatusConfig_hook(doc);

    String strmd5, str;
    serializeJson(doc, strmd5);
    String md5 = md5String(strmd5);
    if (md5 == sconfig.md5)
    {
        return;
    }

    sconfig.md5 = md5;
    doc["md5"] = sconfig.md5;
    serializeJson(doc, str);
    writeFile(statusconfig, str);
}

String getStatusConfigString()
{
    StaticJsonDocument<1024> doc;
    doc["led"] = sconfig.led;
    doc["relay"] = sconfig.relay;
    doc["countdown"] = sconfig.countdown;
    doc["timer"] = sconfig.timer;
    doc["starttime"] = sconfig.starttime;
    doc["endtime"] = sconfig.endtime;
    doc["md5"] = sconfig.md5;
    doc["boottime"] = sconfig.boottime;
    doc["bootfail"] = sconfig.bootfail;

    getStatusConfigString_hook(doc);

    String str;
    serializeJson(doc, str);

    return str;
}

void printStatusConfig()
{
    String str = getStatusConfigString();
    Serial.println(str);
}

void loadMQTTConfig()
{
    String str = readFile(mqttconfig);
    StaticJsonDocument<1024> doc;
    DeserializationError error = deserializeJson(doc, str);
    if (error)
    {
        Serial.println("Failed to deserializeJson str");
        return;
    }

    mconfig.sid = doc["sid"] ? String(doc["sid"]) : String("");
    mconfig.pwd = doc["pwd"] ? String(doc["pwd"]) : String("");
    mconfig.ota = String(doc["ota"]);
    mconfig.host = String(doc["host"]);
    mconfig.topic = String(doc["topic"]);
    mconfig.port = doc["port"];
    mconfig.clientId = doc["clientId"] ? doc["clientId"] : String("");
    mconfig.username = doc["username"] ? String(doc["username"]) : String("");
    mconfig.password = doc["password"] ? String(doc["password"]) : String("");

    loadMQTTConfig_hook(doc);

    bool needSave = false;
    if (mconfig.topic.indexOf("{randid}") >= 0)
    {
        mconfig.topic.replace("{randid}", mac());
        needSave = true;
    }

    if (String("") == mconfig.clientId)
    {
        String tmp = mconfig.topic;
        tmp.replace("oldfox126/esp12s/", "");
        tmp.replace("/", "-");
        mconfig.clientId = tmp;
        needSave = true;
    }

    if (needSave)
    {
        saveMQTTConfig();
    }

    return;
}

void saveMQTTConfig()
{
    String str = getMQTTConfigString();
    writeFile(mqttconfig, str);
}

String getMQTTConfigString()
{
    StaticJsonDocument<1024> doc;
    doc["sid"] = mconfig.sid;
    doc["pwd"] = mconfig.pwd;
    doc["host"] = mconfig.host;
    doc["topic"] = mconfig.topic;
    doc["port"] = mconfig.port;
    doc["ota"] = mconfig.ota;
    doc["clientId"] = mconfig.clientId;
    doc["username"] = mconfig.username;
    doc["password"] = mconfig.password;

    getMQTTConfigString_hook(doc);

    String str;
    serializeJson(doc, str);

    return str;
}

void printMQTTConfig()
{
    String str = getMQTTConfigString();
    Serial.println(str);
}