/*
File:common.h
Memo:通用的函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/common.h"

int flashCount = 0;

void LED_ON()
{
    digitalWrite(LED, LOW);
}

void LED_OFF()
{
    digitalWrite(LED, HIGH);
}

void flash_LED()
{
    flash_LED(1);
}

void flash_LED(int count)
{
    if (0 > count)
    {
        flashCount++;
        if (flashCount >= -count)
        {
            flash_LED(1);
            flashCount = 0;
        }
        return;
    }

    for (unsigned char i = 0; i < count; i++)
    {
        LED_ON();
        delay(50);
        LED_OFF();
        delay(50);
    }
}

unsigned char ledState = 0;
void switch_LED()
{
    if (0 == ledState)
    {
        set_LED(1);
        return;
    }

    set_LED(0);
}

void set_LED(unsigned char value)
{
    ledState = value;
    if (1 == ledState)
    {
        LED_ON();
        ledSub = ledMax;
    }
    else
    {
        LED_OFF();
    }
}

void LED_CONSTANT_LIGHT()
{
    if (1 == sconfig.led)
    {
        if (1 == sconfig.relay)
        {
            set_LED(1);
        }
        else
        {
            set_LED(0);
        }
        return;
    }

    if (1 == ledSub)
    {
        set_LED(0);
    }

    if (ledSub > 0)
    {
        ledSub--;
    }

    return;
}

String md5String(String str)
{
    MD5Builder md5;
    md5.begin();
    md5.add(str);
    md5.calculate();
    return md5.toString();
}

void printFreeMem()
{
    Serial.print("FREE_MEMORY:");
    Serial.println(GET_FREE_MEMORY());
}

String randString(int length)
{
    static String charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    String result;

    srand(system_get_time());
    for (int i = 0; i < length; i++)
    {
        result += String(charset[rand() % charset.length()]);
    }

    return result;
}

byte readKey()
{
    unsigned char count = 0;
    while (true)
    {
        if (1 == digitalRead(KEY))
        {
            return 1;
        }

        // key=0,press key
        count++;
        if (count >= 3)
        {
            return 0;
        }

        delay(10);
    }

    return 1;
}

void showtime(String str)
{
    if (String("") != str)
    {
        Serial.println(str);
    }

    Serial.println(micros());
}

String floatRound(float ft, int num)
{
    char buffer[1000];
    sprintf(buffer, "%.*f", num, ft);
    return String(buffer);
}

uint8_t readReg()
{
    uint8_t reg;
    Serial.readBytes(&reg, 1);
    return reg;
}

unsigned int readSerial()
{
    String str = "readSerial:";
    while (Serial.available() > 0)
    {
        int data = Serial.read();
        str = str + String(data);
    }

    return str.length();
}

bool boot_Init()
{
    boot_Init_hook();

    sconfig.bootfail++;
    if (bootFailMax > sconfig.bootfail)
    {
        saveStatusConfig();
        return true;
    }

    // 如果启动失败次数过多，就自动进入配网界面，可以升级固件救砖
    sconfig.bootfail = 0;
    saveStatusConfig();
    htmlConfig();

    return false;
}

void boot_OK()
{
    sconfig.boottime = rawTime();
    sconfig.bootfail = 0;
    saveStatusConfig();
    boot_OK_hook();
}

// 返回0，定时器未启用
// 返回1，已到启用时间，开关开
// 返回2，已到启用时间，开关关
// 返回3，未到启用时间
unsigned char getTimer()
{
    if (sconfig.timer == 0)
    {
        return 0;
    }

    String HM = String(",") + getHMTime() + String(",");
    if (!sconfig.starttime.isEmpty())
    {
        String starttime = String(",") + sconfig.starttime + String(",");
        if (starttime.indexOf(HM) >= 0)
        {
            return 1;
        }
    }

    if (!sconfig.endtime.isEmpty())
    {
        String endtime = String(",") + sconfig.endtime + String(",");
        if (endtime.indexOf(HM) >= 0)
        {
            return 2;
        }
    }

    return 3;
}

// 返回0，倒计时未开或者未到时间
// 返回1，倒计时已开且到时间
unsigned char ctCount = 60; // 倒计时的秒数
unsigned char getCountdown()
{
    if (0 >= sconfig.countdown)
    {
        return 0;
    }

    if ((1 == sconfig.countdown) and (1 >= ctCount))
    {
        ctCount = 60;
        sconfig.countdown = 0;
        return 1;
    }

    ctCount--;
    if (0 >= ctCount)
    {
        sconfig.countdown--;
        ctCount = 60;
    }

    return 0;
}

float absrate(float f1, float f2)
{
    if (f1 == f2)
    {
        return 0;
    }

    if (0 == f1)
    {
        return 1;
    }

    return abs(f2 - f1) / f1;
}