/*
File:relay.h
Memo:把继电器相关的函数都放在这里，方便移植到使用常规继电器的项目
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __RELAY_H__
#define __RELAY_H__

#include <Arduino.h>

#include "common/common.h"

#include "private/config.h"

void RELAY_ON();
void RELAY_OFF();
void RELAY_KEEP();
void switch_RELAY();
void set_RELAY(unsigned char value);
void release_RELAY();
void RELAY_Ticker();
void mqtt_set_RELAY();
void mqtt_set_RELAY(unsigned char value);

#endif
