/*
File:hook.h
Memo:钩子函数，在通用函数中放置钩子，在私有函数中具体实现不同的功能。
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __HOOK_H__
#define __HOOK_H__

#include <Arduino.h>
#include <Ticker.h>
#include <AsyncMqttClient.h>

#include "common/common.h"
#include "common/files.h"
#include "common/tickers.h"
#include "common/mqtt.h"
#include "common/wifi.h"
#include "common/timeNTP.h"

#include "private/config.h"
#include "private/bl0937.h"
#include "private/relay.h"

void setup_hook();
void boot_OK_hook();
void loop_hook();
void OTA_update_hook();
void One_Tenth_Of_Second_Ticker_hook();
void One_Second_Ticker_hook();

void onMqttMessage_hook(String msg, String str);
void mqtt_Up_Status_hook(StaticJsonDocument<1024> &doc);
void onMqttConnect_hook();
void publishMQTTdiscoverys_hook();

void loadStatusConfig_hook(StaticJsonDocument<1024> &doc);
void saveStatusConfig_hook(StaticJsonDocument<1024> &doc);
void getStatusConfigString_hook(StaticJsonDocument<1024> &doc);

void loadMQTTConfig_hook(StaticJsonDocument<1024> &doc);
void getMQTTConfigString_hook(StaticJsonDocument<1024> &doc);

void Timer_hook();
void KeyPress_hook();

#endif