/*
File:config.h
Memo:需要配置的参数都放在这个文件，免得到处找
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

// ----------common start----------
#ifndef __CONFIG_H__
#define __CONFIG_H__

#include <Arduino.h>
#include <AsyncMqttClient.h>
#include <ESP8266WebServer.h>
#include <Ticker.h>

extern unsigned char ledSub;
extern unsigned char ledMax;
extern Ticker TickerKey, TickerMQTT, TickerSecond, TickerLED;
extern const char *ssid;
extern const char *password;
extern unsigned char needOTA;
extern unsigned char needNTP;
extern unsigned char needMQTTup;
extern unsigned char needSaveStatus;
extern unsigned char needWIFI;
extern unsigned char needReadRadar;
extern unsigned char netFailMax;
extern unsigned char bootFailMax;
extern unsigned int waitHtmlConfigMax;
extern float mqttChangeRate;
extern unsigned long lastPublishTime;
extern bool debug;
extern const String statusconfig;
extern const String mqttconfig;
extern const String version;

#define KEY 0
#define LED 2
// ----------common end----------



// ----------private start----------
#define INA 4
#define INB 5

#define CF1 12
#define CF 13
#define SEL 14

extern unsigned char needReadChip;
extern float VolRate;
extern float CurrentRate;
extern float PowerRate;
extern Ticker TickerRELAY, TickerReadChip;
extern float KWh0;

struct StatusConfig
{
    unsigned char led;
    unsigned char relay;
    unsigned char countdown;
    unsigned char timer;
    unsigned long boottime;
    unsigned char bootfail;
    float KWh;
    String starttime;
    String endtime;
    String time;
    String md5;
    unsigned char reverse;
};

struct MQTTConfig
{
    String clientId;
    String ota;
    String host;
    String topic;
    unsigned int port;
    String username;
    String password;
    float vrate;
    float crate;
    float prate;
};

extern StatusConfig sconfig;
extern MQTTConfig mconfig;
//  ----------private end----------



#endif