/*
File:config.h
Memo:需要配置的参数都放在这个文件，免得到处找
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

// ----------common start----------
#include "private/config.h"

const char *ssid = "qwer";
const char *password = "asdfghjkl";
unsigned char ledSub = 0;
unsigned char ledMax = 100;
unsigned char needOTA = 0;
unsigned char needNTP = 0;
unsigned char needMQTTup = 0;
unsigned char needSaveStatus = 0;
unsigned char needWIFI = 0;
unsigned char needReadRadar = 0;
unsigned char netFailMax = 3;      // 网络失败重试次数
unsigned char bootFailMax = 10;     // 启动失败重试次数
unsigned int waitHtmlConfigMax = 3000; // 网页配网最长等待时间，单位1/10秒，超时自动重启。
float mqttChangeRate = 0.05;           // 只有当数值变化超过0.05(5%)时，MQTT才会发布
unsigned long lastPublishTime = 0;
bool debug = false;
StatusConfig sconfig;
MQTTConfig mconfig;
const String statusconfig = "/status.json";
const String mqttconfig = "/mqtt.json";
Ticker TickerKey, TickerMQTT, TickerSecond, TickerLED;
// ----------common end----------




// ----------private start----------
Ticker TickerRELAY, TickerReadChip;
unsigned char needReadChip = 0;
const String version = "BL0937(2023/9/6 11:26)";

float VolRate = 0.77;
float CurrentRate = 0.83;
float PowerRate = 0.75;
float KWh0 = 0;
// ----------private end----------








