/*
File:bl0937.h
Memo:读取计量芯片的电能数据，尝试兼容不同的计量芯片
Date:2023/6/2
Coder:oldfox126@foxmail.com
目的：为新国标五孔计量插座10A(https://oshwhub.com/oldfox126/xin-guo-biao-wu-kong-ji-liang-cha-zuo-10a) 配套的软件工程，本插座使用新国标五孔外壳，相比老款外壳更容易布线。在保留老款特性(磁保持继电器、电能计量、OTA升级固件)的同时，也解决了最后的短板(电流计数不稳定、外壳无法完美贴合等)。是计量插座的完全体。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __BL0937_H__
#define __BL0937_H__

#include <Arduino.h>

#include "private/config.h"

#define V_REF 1.218
#define R_CURRENT 0.001
#define R_VOLTAGE 1981 //(6 * 330) + 1
#define READING_INTERVAL 3000
#define PULSE_TIMEOUT 1000000

void InitReadChip();
void calculateDefaultMultipliers();
String getDebugInfo();
IRAM_ATTR void CFInterrupt();
IRAM_ATTR void CF1Interrupt();
void readChip();
void readPower();
float getActivePower();
void readyReadVoltage();
void readVoltage();
float getVoltage();
void readyReadCurrent();
void readCurrent();
float getCurrent();
float getEnergy();

#endif