/*
File:main.cpp
Memo:入口主函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/common.h"
#include "common/files.h"
#include "common/tickers.h"
#include "common/mqtt.h"
#include "common/wifi.h"
#include "common/timeNTP.h"

#include "private/config.h"
#include "private/hook.h"

unsigned char WIFIInitLock = 0;

void setup()
{
    Serial.begin(74800);
    Serial.print("ver:");
    Serial.println(version);

    pinMode(KEY, INPUT);
    pinMode(LED, OUTPUT);
    setup_hook();
    flash_LED(3);

    InitJsonConfig();
    if (!boot_Init())
    {
        return;
    }

    WaitKey();
    connectWIFI();

    TickerKey.attach(0.1, One_Tenth_Of_Second_Ticker);
    TickerSecond.attach(1, One_Second_Ticker);
}

void loop()
{
    if (1 == needWIFI)
    {
        needWIFI = 0;
        Serial.println("Reconnect WIFI.");
        if (WIFIInitLock > 0)
        {
            Serial.println("WIFI in Init,Exit.");
            return;
        }

        WIFIInitLock = 1;
        connectWIFI();
        WIFIInitLock = 0;
        return;
    }

    if (1 == needNTP)
    {
        needNTP = 0;
        NTPupdate();
        return;
    }

    if (1 == needOTA)
    {
        needOTA = 0;
        TickerKey.detach();
        TickerSecond.detach();
        OTA_update();
        return;
    }

    if (1 == needSaveStatus)
    {
        needSaveStatus = 0;
        saveStatusConfig();
    }

    if (1 == needMQTTup)
    {
        needMQTTup = 0;
        mqtt_Up_Status();
    }

    loop_hook();
}