/*
File:wifi.h
Memo:WIFI及网络相关函数
Date:2022/10/4
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/wifi.h"

ESP8266WebServer server(80);
ESP8266HTTPUpdateServer httpUpdater;
String sid = "";
String pwd = "";
WiFiState state;

void connectWIFI()
{
    TickerLED.attach(0.1, LED_Ticker2);
    bool flag = true;
    unsigned char netFail = 0;

    while (flag)
    {
        if (netFail >= netFailMax)
        {
            Serial.println("Network connect fail so much times,reboot...");
            ESP.restart();
            delay(200);
            return;
        }

        ESP.wdtFeed();
        if (0 >= InitWIFI())
        {
            netFail++;
            continue;
        }
        printIpConfig();

        if (0 >= InitNTP())
        {
            netFail++;
            continue;
        }

        showDateTime();
        InitMQTT();
        flag = false;
    }
    TickerLED.detach();
}

int InitWIFI()
{
    unsigned char count = 0;
    if (String("") == sid)
    {
        sid = WiFi.SSID();
    }
    if (String("") == pwd)
    {
        pwd = WiFi.psk();
    }

    Serial.print("W.");
    WiFi.mode(WIFI_STA);
    WiFi.setAutoConnect(true);
    WiFi.setAutoReconnect(true);
    WiFi.persistent(true);
    WiFi.begin(sid, pwd);
    while (WiFi.status() != WL_CONNECTED)
    {
        count++;
        /*
        Serial.print("WiFi.status()=");
        Serial.println(WiFi.status());
        Serial.print("WiFi.BSSID()=");
        Serial.println(WiFi.BSSIDstr());
        Serial.print("WiFi.RSSI()=");
        Serial.println(WiFi.RSSI());
        */

        if (11==count)
        {
            Serial.print("D.");

            WiFi.disconnect(true);
            WiFi.mode(WIFI_OFF);
            WiFi.shutdown(state);

            WiFi.resumeFromShutdown(state);

            WiFi.mode(WIFI_STA);
            WiFi.begin(sid, pwd);
        } else if (count > 20)
        {
            return -1;
        }

        ESP.wdtFeed();
        Serial.print(".");
        delay(500);
    }

    Serial.println("============WiFi CONNECTED============");
    return 1;
}

void smartConfig()
{
    ESP.wdtFeed();
    TickerLED.attach(0.5, LED_Ticker);
    WiFi.mode(WIFI_STA);
    Serial.print("Wait for Smartconfig.");
    WiFi.beginSmartConfig();
    while (1)
    {
        ESP.wdtFeed();
        Serial.print(".");
        if (WiFi.smartConfigDone())
        {
            Serial.println("SmartConfig Success,ready to reboot.");
            Serial.printf("SSID:%s\r\n", WiFi.SSID().c_str());
            Serial.printf("PSW:%s\r\n", WiFi.psk().c_str());
            ESP.restart();
            delay(200);
            return;
        }
        delay(3000);
    }
}

void showIndex()
{
    String html = readFile("/index.html");
    html.replace("{ver}", version);
    html.replace("{ssid}", WiFi.SSID());
    html.replace("{password}", WiFi.psk());
    html.replace("{ota}", mconfig.ota);
    html.replace("{host}", mconfig.host);
    html.replace("{topic}", mconfig.topic);
    html.replace("{port}", String(mconfig.port));
    html.replace("{mqttuname}", mconfig.username);
    html.replace("{mqttpwd}", mconfig.password);

    server.send(200, "text/html", html);
}

void saveConfig()
{
    sid = server.arg("ssid");
    pwd = server.arg("password");
    String ota = server.arg("ota");
    String host = server.arg("host");
    String topic = server.arg("topic");
    String port = server.arg("port");
    String username = server.arg("mqttuname");
    String password = server.arg("mqttpwd");

    sid.trim();
    pwd.trim();
    ota.trim();
    host.trim();
    topic.trim();
    port.trim();
    username.trim();
    password.trim();

    bool hasSAVE = false;
    if (ota != "")
    {
        mconfig.ota = ota;
        saveMQTTConfig();
        hasSAVE = true;
    }

    if ((mconfig.host != "") and (mconfig.topic != "") and (mconfig.port != 0))
    {
        mconfig.host = host;
        mconfig.topic = topic;
        mconfig.port = (unsigned int)port.toInt();
        mconfig.username = username;
        mconfig.password = password;
        saveMQTTConfig();
        hasSAVE = true;
    }

    if ((sid != "") and (pwd != ""))
    {
        Serial.println("Save Wifi SSID.");
        hasSAVE = true;
    }

    if (hasSAVE)
    {
        TickerLED.detach();
        Serial.println("Save Config.");
        connectWIFI();
    }
}

void handleNotFound()
{
    String html = "File Not Found\n\n";
    html += "URI: ";
    html += server.uri();
    html += "\nMethod: ";
    html += (server.method() == HTTP_GET) ? "GET" : "POST";
    html += "\nArguments: ";
    html += server.args();
    html += "\n";
    for (uint8_t i = 0; i < server.args(); i++)
    {
        html += " " + server.argName(i) + ": " + server.arg(i) + "\n";
    }
    server.send(404, "text/plain", html);
}

void htmlConfig()
{
    Serial.println("htmlConfig");
    TickerLED.attach(0.1, HtmlConfig_Ticker);
    WiFi.disconnect();
    WiFi.mode(WIFI_AP);
    WiFi.softAP(ssid, password);
    Serial.println("AP setup Done.");

    IPAddress myIP = WiFi.softAPIP();
    Serial.print("AP IP address:");
    Serial.println(myIP);
    Serial.print("ssid:");
    Serial.println(ssid);
    Serial.print("password:");
    Serial.println(password);

    if (MDNS.begin("esp8266"))
    {
        Serial.println("MDNS responder started");
    }

    server.on("/", showIndex);
    server.on("/config", HTTP_GET, saveConfig);
    server.onNotFound(handleNotFound);

    httpUpdater.setup(&server);
    server.begin();
    MDNS.addService("http", "tcp", 80);
    Serial.println("HTTP server started");
    while (1)
    {
        ESP.wdtFeed();
        server.handleClient();
        MDNS.update();
    }
}

void WaitKey()
{
    int i, key;

    Serial.print("Wait 1 second.");
    for (i = 0; i < 10; i++)
    {
        ESP.wdtFeed();
        key = readKey();
        if (0 == key)
        {
            break;
        }
        else
        {
            Serial.print(".");
            delay(100);
        }
    }

    if (i >= 10)
    {
        Serial.println("End");
        return;
    }

    Serial.println("break.");
    Serial.print("What do you Want?");
    for (i = 0; i < 10; i++)
    {
        ESP.wdtFeed();
        delay(1000);
        key = digitalRead(KEY);
        if (0 != key)
        {
            break;
        }
        Serial.print(".");
    }

    if (i >= 4)
    {
        // wechat scan QRcode to config wifi
        smartConfig();
        return;
    }

    htmlConfig();
}

void printIpConfig()
{
    Serial.println(WiFi.localIP());
    Serial.println(WiFi.subnetMask());
    Serial.println(WiFi.gatewayIP());
    Serial.println(WiFi.dnsIP());
}

unsigned int waitCount = 0;
void HtmlConfig_Ticker()
{
    switch_LED();
    waitCount++;
    if (waitHtmlConfigMax > waitCount)
    {
        return;
    }

    TickerLED.detach();
    Serial.println("HtmlConfig OverTime,Reboot...");
    ESP.restart();
    delay(200);
    return;
}