/*
File:timeNTP.h
Memo:NTP网络对时相关时间函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/timeNTP.h"

WiFiUDP ntpUDP;
NTPClient timeClient(ntpUDP, "cn.ntp.org.cn", 3600, 60000);

int tryNtpServers()
{
    char *arr[] = {(char *)"cn.ntp.org.cn", (char *)"cn.pool.ntp.org", (char *)"ntp.aliyun.com", (char *)"ntp.ntsc.ac.cn", (char *)"ntp.tencent.com", (char *)"time.edu.cn"};
    unsigned char count = 0;
    Serial.print("N...");

    for (char *server : arr)
    {
        ESP.wdtFeed();
        Serial.print("NTP Server:");
        Serial.print(server);

        timeClient.setPoolServerName(server);
        timeClient.setTimeOffset(8 * 3600);
        timeClient.begin();
        timeClient.update();

        if (timeClient.isTimeSet())
        {
            Serial.println(",Done.");
            timeClient.end();
            return count;
        }

        count++;
        Serial.println(",Change NTP Server.");
        delay(500);
    };

        timeClient.end();
    return -1;
}

int InitNTP()
{
    if (0 > tryNtpServers())
    {
        Serial.println("NTP can not Init!");
        return 0;
    }

    Serial.println("============NTP Init============");
    return 1;
}

int NTPupdate()
{
    if (0 > tryNtpServers())
    {
        Serial.println("NTP can not Update!");
        return 0;
    }

    Serial.println("============NTP Update============");
    return 1;
}

String getDateTime()
{
    return timeClient.getFormattedTime();
}

String getTime()
{
    return timeClient.getFormattedTime();
}

String getHMTime()
{
    unsigned long rawTime = timeClient.getEpochTime();
    unsigned long hours = (rawTime % 86400L) / 3600;
    String hoursStr = hours < 10 ? "0" + String(hours) : String(hours);

    unsigned long minutes = (rawTime % 3600) / 60;
    String minuteStr = minutes < 10 ? "0" + String(minutes) : String(minutes);

    unsigned long seconds = rawTime % 60;
    String secondStr = seconds < 10 ? "0" + String(seconds) : String(seconds);

    return hoursStr + ":" + minuteStr;
}

String getMSTime()
{
    unsigned long rawTime = timeClient.getEpochTime();
    unsigned long hours = (rawTime % 86400L) / 3600;
    String hoursStr = hours < 10 ? "0" + String(hours) : String(hours);

    unsigned long minutes = (rawTime % 3600) / 60;
    String minuteStr = minutes < 10 ? "0" + String(minutes) : String(minutes);

    unsigned long seconds = rawTime % 60;
    String secondStr = seconds < 10 ? "0" + String(seconds) : String(seconds);

    return minuteStr + ":" + secondStr;
}

void showDateTime()
{
    Serial.println(getDateTime());
}

int hour()
{
    unsigned long rawTime = timeClient.getEpochTime();
    unsigned long hh = (rawTime % 86400L) / 3600;

    return hh;
}

int minute()
{
    unsigned long rawTime = timeClient.getEpochTime();
    unsigned long mm = (rawTime % 3600) / 60;

    return mm;
}

int second()
{
    unsigned long rawTime = timeClient.getEpochTime();
    int ss = rawTime % 60;

    return ss;
}

unsigned long rawTime()
{
    return timeClient.getEpochTime();
}