/*
File:tickers.h
Memo:中断定时器相关函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#include "common/tickers.h"

unsigned char sec = 0;
unsigned char pressCount = 0;

void KeyPress_Ticker()
{
    unsigned char keyState = readKey();
    if (0 == keyState)
    {
        pressCount++;
        if (pressCount > 34) // readKey return value need 30ms
        {
            Serial.println("press key 10s to reboot");
            ESP.restart();
            delay(200);
        }
        return;
    }

    if (1 == keyState)
    {
        if (pressCount > 0)
        {
            pressCount = 0;
            needSaveStatus = 1;
            KeyPress_hook();
            return;
        }
    }
}

void One_Tenth_Of_Second_Ticker()
{
    KeyPress_Ticker();
    MQTT_Ticker();
	One_Tenth_Of_Second_Ticker_hook();
}

void One_Second_Ticker()
{
    //(0 == hour()) and
    if ((0 == minute()) and (0 == second()))
    {
        needNTP = 1;
    }

    Timer_hook();
}

void MQTT_Ticker()
{
    needMQTTup = 1;
}

void LED_Ticker()
{
    switch_LED();
}

unsigned char ledCount = 0;
void LED_Ticker2()
{
    ledCount++;
    if (ledCount >= 10)
    {
        ledCount = 0;
    }

    if ((ledCount == 0) or (ledCount == 2))
    {
        set_LED(1);
    }
    else
    {
        set_LED(0);
    }
}

void LED_Ticker3()
{
    ledCount++;
    if (ledCount >= 10)
    {
        ledCount = 0;
    }

    if ((ledCount == 0) or (ledCount == 2) or (ledCount == 4))
    {
        set_LED(1);
    }
    else
    {
        set_LED(0);
    }
}