/*
File:ota.h
Memo:OTA空中升级相关函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __OTA_H__
#define __OTA_H__

#include <Arduino.h>
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>
#include <ESP8266httpUpdate.h>
#include <Ticker.h>
#include <string.h>
#include <AsyncMqttClient.h>

#include "common/common.h"
#include "common/files.h"
#include "common/timeNTP.h"
#include "common/tickers.h"

#include "private/hook.h"

void OTA_update();
void OTA_error(int err);
void OTA_progress(int cur, int total);
void OTA_finished();
void OTA_started();

#endif