/*
File:mqtt.h
Memo:MQTT相关函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __MQTT_H__
#define __MQTT_H__

#include <Arduino.h>
#include <ArduinoJson.h>
#include <Ticker.h>
#include <string.h>
#include <AsyncMqttClient.h>
#include <LittleFS.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>
#include <ESP8266httpUpdate.h>

#include "common/common.h"
#include "common/files.h"
#include "common/ota.h"
#include "common/timeNTP.h"

#include "private/config.h"
#include "private/hook.h"

void InitMQTT();
void onMqttConnect(bool sessionPresent);
void onMqttDisconnect(AsyncMqttClientDisconnectReason reason);
void onMqttMessage(char *topic, char *payload, AsyncMqttClientMessageProperties properties, size_t len, size_t index, size_t total);
void mqtt_Up_Status();
String getMqttDebugInfo();
void publishMQTTdiscovery(String topic, StaticJsonDocument<512> &doc);
void publishMQTTdiscoverys();

#endif
