/*
File:common.h
Memo:通用的函数
Date:2022/9/10
Coder:oldfox126@foxmail.com
目的：为磁保持WIFI计量插座(220V10A)(https://oshwhub.com/oldfox126/ci-bao-chi-wifi-ji-liang-cha-zuo) 配套的软件工程，该项目是在[磁保持WIFI智能插座]的基础上增加了计量功能，可显示实时电压V/电流mA/功率W，以及总功耗KWh。。
开源协议: CC-BY-NC-SA 3.0
*/

#ifndef __COMMON_H__
#define __COMMON_H__

#include <Arduino.h>
#include <MD5Builder.h>

#include "common/tickers.h"
#include "common/wifi.h"

#include "private/config.h"

void LED_ON();
void LED_OFF();
void flash_LED();
void flash_LED(int count);
void switch_LED();
void set_LED(unsigned char value);
void LED_CONSTANT_LIGHT();
String md5String(String str);
void printFreeMem();
String randString(int length);
byte readKey();
void showtime(String str = "");
String floatRound(float ft, int num);
uint8_t readReg();
unsigned int readSerial();
bool boot_Init();
void boot_OK();
unsigned char getTimer();
unsigned char getCountdown();
float absrate(float f1, float f2);

#endif
